<?php
/**
 * @package     Joomla.Site
 * @subpackage  mod_custom
 *
 * @copyright   Copyright (C) 2005 - 2015 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;
$document = JFactory::getDocument();
//$document->addScript('modules/mod_tm_countdown/js/jquery.final-countdown.min.js');
//$document->addScript('modules/mod_tm_countdown/js/kinetic.js');
$document->addScript('modules/mod_tm_countdown/js/jquery.classycountdown.min.js');
$document->addScript('modules/mod_tm_countdown/js/jquery.knob.js');
$document->addScript('modules/mod_tm_countdown/js/jquery.throttle.js');

$columns = (int)$params->get('columns');


$days_border_color = $params->get('days_border_color');
$days_border_width = $params->get('days_border_width');

$hours_border_color = $params->get('hours_border_color');
$hours_border_width = $params->get('hours_border_width');

$minutes_border_color = $params->get('minutes_border_color');
$minutes_border_width = $params->get('minutes_border_width');

$seconds_border_color = $params->get('seconds_border_color');
$seconds_border_width = $params->get('seconds_border_width');

$cols = 4;

$items_border_color = $params->get('items_border_color');

?>

<?php if ($params->get('pretext')): ?>
  <div class="pretext">
    <?php echo $params->get('pretext') ?>
  </div>
<?php endif;?>

<div id="mod_tm_countdown_<?php echo $module->id; ?>" class="mod_tm_countdown mod_tm_countdown_<?php echo $params->get('countdown_type');?> mod_tm_countdown__<?php echo $moduleclass_sfx ?> cols-<?php echo $cols;?>"></div>

<?php

	$sdate = strtotime($params->get('start_date'));
	$edate = strtotime($params->get('end_date'));
	$nowtime = time();

	$document->AddScriptDeclaration("
		;(function($){
			$(window).on('load', function() {
				$('#mod_tm_countdown_".$module->id."').ClassyCountdown({
		            end: '".$edate."',
                    now: '".$nowtime."',
		            labels: true,
		            labelsOptions: {
		                lang: {
		                    days: '".JText::_('MOD_TM_COUNTDOWN_DAYS')."',
		                    hours: '".JText::_('MOD_TM_COUNTDOWN_HOURS')."',
		                    minutes: '".JText::_('MOD_TM_COUNTDOWN_MINUTES')."',
		                    seconds: '".JText::_('MOD_TM_COUNTDOWN_SECONDS')."'
		                },
		                style: 'font-size: inherit;'
		            },
		            style: {
		                element: '',
		                textResponsive: 1,
		                days: {
		                    gauge: {
		                        thickness: ".$days_border_width.",
		                        bgColor: '".$items_border_color."',
		                        fgColor: '".$days_border_color."'
		                    }
		                },
		                hours: {
		                    gauge: {
		                        thickness: ".$hours_border_width.",
		                        bgColor: '".$items_border_color."',
		                        fgColor: '".$hours_border_color."'
		                    }
		                },
		                minutes: {
		                    gauge: {
		                        thickness: ".$minutes_border_width.",
		                        bgColor: '".$items_border_color."',
		                        fgColor: '".$minutes_border_color."'
		                    }
		                },
		                seconds: {
		                    gauge: {
		                        thickness: ".$seconds_border_width.",
		                        bgColor: '".$items_border_color."',
		                        fgColor: '".$seconds_border_color."'
		                    }
		                }

		            }
		        });
			});
		})(jQuery);	
	");

?>
